//---------------------------------------------------------------------------
#include "Explosao.h"
//---------------------------------------------------------------------------
TExplode::TExplode(char *nomesprite, int cortransp, int tanima, int width, int height)
	:TSprite(nomesprite,false,cortransp,width,height)
{
	lista_explode = new TLista();
	lista_explode->funcao((pfunc)(comp_id));
	colisao = NULL;
	this->tanima=tanima;
}
//---------------------------------------------------------------------------
TExplode::~TExplode()
{
	while(lista_explode->num_itens()>0)
	{
		delete (CRT_EXPLODE *)(lista_explode->remove_item(0));
	}
	delete lista_explode;	
}
//---------------------------------------------------------------------------
bool comp_id(void *obj1,void *obj2)
{
		CRT_EXPLODE *ob1, *ob2;
		
		ob1 = (CRT_EXPLODE *)obj1;
		ob2 = (CRT_EXPLODE *)obj2;
		
		if(ob1->tempo==ob2->tempo)
			return true;
		return false;
}
//---------------------------------------------------------------------------
void TExplode::AdicionaExplosao(BITMAP *bmp, int x, int y, int msec)
{
	CRT_EXPLODE *ponto;	
	
	ponto = new CRT_EXPLODE;
	
	ponto->x = x;
	ponto->y = y;
	ponto->ani = 1;
	ponto->tempo = msec;

	Draw(bmp,ponto->x,ponto->y,0);

	lista_explode->adiciona(ponto);
	
	if(colisao!=NULL)
		colisao(ponto->x, ponto->y);
}
//---------------------------------------------------------------------------
void TExplode::DrawExplosao(BITMAP *bmp, int msec)
{
	CRT_EXPLODE *atual;
	int i=0;
	
	while(i<lista_explode->num_itens())
	{
		atual = (CRT_EXPLODE *)lista_explode->obtem(i);
		Draw(bmp,atual->x,atual->y,atual->ani);
		
		if(colisao!=NULL)
			colisao(atual->x, atual->y);
		
		if((msec-atual->tempo)>tanima)
		{
			atual->ani++;
			atual->tempo=msec;
			if(atual->ani>=QuantSprites())
				delete (CRT_EXPLODE *)(lista_explode->remove_item(i));
		}
		else
			i++;
	}
}
//---------------------------------------------------------------------------
void TExplode::SetColisao(void (*colisao)(int, int))
{
	this->colisao=colisao;	
}
//---------------------------------------------------------------------------
